/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.http;

import filenet.pe.ceutils.ConnectionPoint;
import filenet.pe.ceutils.ConnectionPoints;
import filenet.pe.peorb.client.ClientInfoUtilities;
import filenet.sim.appserver.VWSIMDocHelper;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWUserInfo;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.Configuration;
import filenet.vw.soap.server.VWSOAPSessionInfo;
import filenet.ws.listener.axis.rm.WSRMCallback;
import filenet.ws.listener.axis.rm.WSRMProvider;
import filenet.ws.listener.axis.rm.WSUUIDGenFactory;
import filenet.ws.listener.uddi.inquiry_v2.uddi_org.WSUddiManager;
import filenet.ws.listener.utils.Constants;
import filenet.ws.listener.utils.VWSessionManager;
import filenet.ws.listener.utils.WSDLManager;
import filenet.ws.listener.utils.WSListenerProperties;
import filenet.ws.utils.WSConstants;
import filenet.ws.utils.schema.PESchemaHelper;
import filenet.ws.utils.schema.WSSchemaUtilsEx;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sandesha.server.Sender;
import org.apache.sandesha.server.SenderWorker;
import org.apache.sandesha.storage.Callback;

public class WSListenerServlet
extends HttpServlet {
    private static final long serialVersionUID = 7465L;
    private static final Object g_syncObject;
    protected Boolean m_WSDLInit = Boolean.FALSE;
    protected static Logger logger;
    private static final String m_className = "WSListenerServlet";
    private static Object syncObj;
    private static long P8BPMWSBROKER_PROPERTIES_LAST_MODIFIED;
    private WSListenerProperties m_wsListenerProperties = null;
    private static Properties wsMappings;
    private static String P8BPMWSBROKER_PROPERTIES_FILENAME;
    private static String LOCAL_P8BPMWSBROKER_PROPERTIES_FILENAME;
    private boolean m_baseURLSet = false;
    private static String LF;
    private static String GENERIC_HELP_STRING;
    private static final int ADMIN_UNSUPPORTED = -1;
    private static final int ADMIN_SET_DBG = 0;
    private static final int ADMIN_SET_REQ_DBG = 1;
    private static final int ADMIN_UNSET_DBG = 2;
    private static final int ADMIN_UNSET_REQ_DBG = 3;
    private static final int ADMIN_CLEAR_DBG = 4;
    private static final int ADMIN_CLEAR_REQ_DBG = 5;
    private static final int ADMIN_SHOW_DBG = 6;
    private static final int ADMIN_SHOW_REQ_DBG = 7;
    private static final int ADMIN_CLEAR_CACHES = 8;
    private static final int ADMIN_CLASS_LOADER = 9;
    private static final int ADMIN_TRACKING_ON = 10;
    private static final int ADMIN_TRACKING_OFF = 11;
    private static final int ADMIN_SET_PROPERTY = 12;
    private static final int ADMIN_VIEW_RPC_TIMING = 13;
    private static final int ADMIN_RESET_RPC_TIMING = 14;
    private static final int ADMIN_HELP = 15;
    private static final String[] G_ADMIN_PATHS;
    private static final String[] G_ADMIN_PATHS_HELP;
    private static final String CLASS_NAME = "classname";
    private static String m_listenerLocalHost;
    private String m_CEURI = null;
    private boolean m_CEURISet = false;
    private static final int LIST_UNSUPPORTED = -1;
    private static final int LIST_CP = 0;
    private static final int LIST_QUEUES = 1;
    private static final int LIST_ROSTERS = 2;
    private static final int LIST_WC = 3;
    private static final int LIST_WC2 = 4;
    private static final String[] G_LIST_PATHS;
    private static final String[] G_LIST_PATHS_HELP;

    private String getMyConnectionPointAsSetByApplet() {
        String res = null;
        String m_method = "getMyConnectionPointAsSetByApplet";
        try {
            WSListenerProperties props = WSListenerProperties.instanceFromFileName(LOCAL_P8BPMWSBROKER_PROPERTIES_FILENAME, null);
            if (props != null) {
                res = props.getProperty("listener.connectionpoint");
                props = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getWSListenerProperties(String cpName) {
        String m_method = "getWSListenerProperties";
        try {
            File f = new File(P8BPMWSBROKER_PROPERTIES_FILENAME);
            if (f.exists()) {
                boolean getIt = false;
                long lastModified = f.lastModified();
                Object object = syncObj;
                synchronized (object) {
                    boolean bl = getIt = P8BPMWSBROKER_PROPERTIES_LAST_MODIFIED < lastModified;
                    if (getIt) {
                        P8BPMWSBROKER_PROPERTIES_LAST_MODIFIED = lastModified;
                        this.m_wsListenerProperties = null;
                        if (logger.isFinest()) {
                            logger.finest(m_className, "getWSListenerProperties", "REFRESH the PROPERTIES FILE!!!");
                        }
                    }
                }
            }
            if (this.m_wsListenerProperties == null) {
                this.m_wsListenerProperties = WSListenerProperties.instanceFromFileName(P8BPMWSBROKER_PROPERTIES_FILENAME, cpName);
            } else {
                this.m_wsListenerProperties.setStanza(cpName);
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, "getWSListenerProperties", e);
        }
    }

    protected static boolean getPOTracking(boolean defaultValue) {
        if (P8BPMWSBROKER_PROPERTIES_FILENAME == null) {
            return false;
        }
        try {
            WSListenerProperties props = WSListenerProperties.instanceFromFileName(P8BPMWSBROKER_PROPERTIES_FILENAME, null);
            String s = props.getPropertyNoStanza("filenet.pe.po.tracking", null);
            props = null;
            if (s == null) {
                return defaultValue;
            }
            return new Boolean(s);
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getBaseURLFromWSListenerProperties() {
        if (this.m_wsListenerProperties == null) {
            return null;
        }
        return this.m_wsListenerProperties.getProperty("listener.base.url");
    }

    private String getMyRequestBaseURL(HttpServletRequest request) {
        String res = (String)request.getAttribute("P8BPM.wsBaseUrl");
        if (res != null) {
            return res;
        }
        String urlHost = request.getServerName();
        if (WSConstants.isLoopbackAddress(urlHost)) {
            try {
                urlHost = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        StringBuffer url = new StringBuffer();
        String scheme = request.getScheme();
        String sPort = "";
        String sContextPath = request.getContextPath();
        int port = request.getServerPort();
        url.append(scheme).append("://").append(urlHost);
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443 || port != -1) {
            sPort = String.valueOf(port);
            url.append(':').append(sPort);
        }
        url.append(sContextPath).append("/").append("P8BPMWSBroker");
        res = url.toString();
        request.setAttribute("P8BPM.wsBaseUrl", (Object)res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBaseURL(HttpServletRequest request) {
        if (this.m_wsListenerProperties == null || this.m_baseURLSet) {
            return;
        }
        WSListenerProperties wSListenerProperties = this.m_wsListenerProperties;
        synchronized (wSListenerProperties) {
            String baseURL = this.getBaseURLFromWSListenerProperties();
            if (baseURL != null && baseURL.indexOf("host:###") == -1) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "setBaseURL", baseURL);
                }
                this.m_baseURLSet = true;
                return;
            }
            baseURL = this.getMyRequestBaseURL(request);
            if (logger.isFinest()) {
                logger.finest(m_className, "setBaseURL", baseURL);
            }
            this.m_wsListenerProperties.setProperty("listener.base.url", baseURL);
            this.m_baseURLSet = true;
        }
    }

    private void getMappings(String s) {
        String m_method = "getMappings:" + s;
        logger.entering(m_className, m_method);
        StringTokenizer st = new StringTokenizer(s, ",;");
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            wsMappings.setProperty(key, st.nextToken());
        }
        logger.exiting(m_className, m_method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        String m_method = "init";
        try {
            String timeOutValue;
            String traceFile;
            String traceOption;
            logger.entering(m_className, "init");
            ServletConfig config = this.getServletConfig();
            ServletContext context = config.getServletContext();
            InputStream inStream = null;
            try {
                inStream = context.getResourceAsStream("/WEB-INF/P8BPMWSBroker.properties");
                LOCAL_P8BPMWSBROKER_PROPERTIES_FILENAME = context.getRealPath("WEB-INF/P8BPMWSBroker.properties");
                P8BPMWSBROKER_PROPERTIES_FILENAME = WSListenerProperties.getRealPathWithDefault(inStream, true, LOCAL_P8BPMWSBROKER_PROPERTIES_FILENAME);
            }
            catch (Throwable t) {
                logger.throwing(m_className, "init", t);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (Exception e) {}
                }
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "init", P8BPMWSBROKER_PROPERTIES_FILENAME);
            }
            if ((traceOption = config.getInitParameter("filenet.ws.listener.tracing")) != null) {
                WSListenerServlet.setPrivilegedSystemProperty("filenet.ws.listener.tracing", traceOption);
            }
            if ((traceFile = config.getInitParameter("filenet.ws.listener.tracefile")) != null) {
                WSListenerServlet.setPrivilegedSystemProperty("filenet.ws.listener.tracefile", traceFile);
            }
            if ((timeOutValue = config.getInitParameter("VWSessionTimeout")) == null) {
                timeOutValue = "20";
            }
            try {
                long l = Long.parseLong(timeOutValue) * 60L * 1000L;
                VWSessionManager.setTimeOut(l);
            }
            catch (Exception e) {
                // empty catch block
            }
            String mappings = config.getInitParameter("WSMappings");
            if (mappings == null) {
                mappings = "*,/axis/services/P8BPMWSProcessor";
            }
            this.getMappings(mappings);
            this.getCEURI(context);
        }
        catch (Exception e) {
            logger.throwing(m_className, "init", e);
            logger.severe(m_className, "init", e.getMessage());
        }
        finally {
            logger.exiting(m_className, "init");
        }
    }

    public void destroy() {
        VWSessionManager.releaseResources();
        PESchemaHelper.ClearCache();
    }

    private String checkSlashes(String pathInfo) {
        if (pathInfo.length() > 1 && pathInfo.charAt(0) == '/' && pathInfo.charAt(1) == '/') {
            pathInfo = pathInfo.substring(1);
        }
        return pathInfo;
    }

    private String getMyConnectionPoint4Request(String pathInfo, HttpServletRequest request) throws VWException {
        String m_method = "getMyConnectionPointEx:" + pathInfo;
        String cpName = null;
        if ((pathInfo = this.checkSlashes(pathInfo)).startsWith("/wscp")) {
            int nextSlash = pathInfo.indexOf(47, "/wscp".length());
            if (nextSlash != -1) {
                cpName = this.getCPFromPath(pathInfo.substring(0, nextSlash), "/wscp");
            }
            pathInfo = this.checkSlashes(pathInfo.substring(nextSlash));
        }
        if (cpName == null) {
            cpName = this.getMyConnectionPointAsSetByApplet();
        }
        if (cpName == null) {
            cpName = this.getCPMatchingLocalBaseURL(this.getMyRequestBaseURL(request));
        }
        if (cpName != null) {
            request.setAttribute("P8BPM.wsCurrentCPName", (Object)cpName);
            WSListenerProperties thisProperties = null;
            try {
                thisProperties = WSListenerProperties.instanceFromFileName(P8BPMWSBROKER_PROPERTIES_FILENAME, cpName);
            }
            catch (Exception e) {
                thisProperties = this.m_wsListenerProperties;
            }
            if (thisProperties != null) {
                thisProperties.WSRMSandeshaSettings();
                request.setAttribute("P8BPM.wsListenerProperties", (Object)thisProperties);
            }
        } else {
            VWException vwex = new VWException("filenet.ws.listener.http.WSListenerServlet.noConnectionPointDefined", "No connection point was defined for Process Orchestration application.  Please use the Component Manager to configure a connection point.");
            logger.throwing(m_className, m_method, vwex);
            throw vwex;
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "Using ConnectionPoint = " + cpName);
        }
        return pathInfo;
    }

    private String getCPMatchingLocalBaseURL(String baseURL) {
        String res = null;
        String m_method = "getCPMatchingLocalBaseURL:" + baseURL;
        try {
            WSListenerProperties props = WSListenerProperties.instanceFromFileName(P8BPMWSBROKER_PROPERTIES_FILENAME, null);
            if (props == null) {
                return res;
            }
            String[] stanzas = props.getStanzasForListenerBaseURL(baseURL);
            int nStanzas = stanzas == null ? 0 : stanzas.length;
            int j = "listener.base.url".length() + 1;
            for (int i = 0; i < nStanzas; ++i) {
                int stanzaLength;
                int n = stanzaLength = stanzas[i] == null ? 0 : stanzas[i].length();
                if (j > stanzaLength) continue;
                res = stanzas[i].substring(j);
                break;
            }
            if (res == null) {
                res = props.getProperty("cm.router");
            }
            props = null;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, res);
        }
        return res;
    }

    private VWSession getVWSessionFromPathQueryString(String cpName, String queryString) throws Throwable {
        int nProps;
        if (queryString == null) {
            return null;
        }
        if ((queryString = queryString.trim()).length() == 0) {
            return null;
        }
        String m_method = "getVWSessionFromPathQueryString:" + cpName + ",queryString=" + queryString;
        String user = null;
        String pw = null;
        String ceURI = this.m_CEURI;
        String[] props = queryString.split("&");
        int n = nProps = props == null ? 0 : props.length;
        if (nProps == 1) {
            return null;
        }
        for (int i = 0; i < nProps; ++i) {
            String[] aProp = props[i].split("=");
            if (aProp.length == 1) continue;
            String name = aProp[0];
            String value = aProp[1];
            if (name.equalsIgnoreCase("user")) {
                user = value;
                continue;
            }
            if (name.equalsIgnoreCase("pw")) {
                pw = value;
                continue;
            }
            if (!name.equals("ceuri")) continue;
            ceURI = value;
        }
        if (user == null || pw == null) {
            return null;
        }
        VWSession ses = VWSessionManager.getVWSession(user, pw, cpName, ceURI);
        logger.finest(m_className, m_method, "GOTIT");
        return ses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String m_method = "doGet";
        logger.entering(m_className, "doGet");
        try {
            boolean hasWSListener;
            VWSession curVWSession;
            String s = request.getPathInfo();
            String pathInfo = "";
            if (s != null) {
                pathInfo = WSConstants.UTF8Decode(s);
            }
            if ((pathInfo = this.getMyConnectionPoint4Request(pathInfo, request)) != null) {
                pathInfo = pathInfo.trim();
            }
            this.getWSListenerProperties((String)request.getAttribute("P8BPM.wsCurrentCPName"));
            this.setCEURI();
            this.setBaseURL(request);
            this.setListenerLocalHost(request);
            String queryString = request.getQueryString();
            if (logger.isFinest()) {
                logger.finest(m_className, "doGet", "pathInfo=" + pathInfo + ", queryString=" + queryString);
            }
            boolean hasVWSession = (curVWSession = this.getVWSessionFromPathQueryString((String)request.getAttribute("P8BPM.wsCurrentCPName"), queryString)) != null;
            boolean bl = hasWSListener = this.m_wsListenerProperties != null;
            if (queryString != null && queryString.startsWith("op=updateDocStatus") && hasWSListener) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "doGet", "Handling PS Doc Update!");
                }
                WSListenerServlet wSListenerServlet = this;
                synchronized (wSListenerServlet) {
                    VWSIMDocHelper helper = new VWSIMDocHelper(request, response, this.m_wsListenerProperties.getUserName(), this.m_wsListenerProperties.getPassword());
                    helper.process();
                }
                return;
            }
            if (hasWSListener && pathInfo.startsWith("/sso")) {
                PrintWriter out = response.getWriter();
                out.println("listener.base.url=[" + this.m_wsListenerProperties.getProperty("listener.base.url") + "]");
            }
            if (pathInfo.startsWith("/wc/")) {
                if ((pathInfo = pathInfo.substring("/wc/".length())).length() == 0) {
                    throw new MalformedURLException(pathInfo);
                }
                int dtdIndex = pathInfo.lastIndexOf(".dtd");
                if (dtdIndex > 0) {
                    int jj = pathInfo.lastIndexOf(47, dtdIndex);
                    String dtdName = pathInfo.substring(jj + 1);
                    this.genDTD(response, dtdName);
                    return;
                }
                if (queryString == null || queryString.startsWith("wsdl") || queryString.startsWith("wf")) {
                    this.getWorkClassWSDLorWF(request, response, pathInfo, queryString == null ? false : queryString.startsWith("wf"), curVWSession);
                    return;
                }
                throw new VWException("filenet.ws.listener.http.WSListenerServlet.unsupportedQueryString", "Query String {0} is not supported.", queryString);
            }
            if ((hasWSListener || hasVWSession) && pathInfo.startsWith("/list")) {
                this.listFunctions(pathInfo, queryString, request, response, curVWSession);
                return;
            }
            if (pathInfo.startsWith(Constants._XSD_)) {
                this.fetchXSD(pathInfo, queryString, request, response, curVWSession);
                return;
            }
            if (pathInfo.startsWith("/admin")) {
                this.adminFunctions(pathInfo, queryString, request, response);
                return;
            }
            if (pathInfo.startsWith("/uddiv2/") && (hasVWSession || hasWSListener)) {
                this.UDDIFunctions(pathInfo, queryString, request, response, curVWSession);
                return;
            }
            if (!this.m_WSDLInit.booleanValue() && hasWSListener) {
                this.loadWSDLClasses();
            }
            this.printRequestInfo(request, response, false, true, null);
        }
        catch (Throwable e) {
            this.reportTroubleInGet(e, response);
            return;
        }
        finally {
            logger.exiting(m_className, "doGet");
        }
    }

    private boolean checkAccess(HttpServletRequest request) {
        try {
            VWSession vwses;
            String m_method = "checkAccess";
            VWSOAPSessionInfo ses = VWSOAPSessionInfo.getSessionInfoFromWorkplace(this.getServletConfig().getServletContext(), request);
            String user = ses.getUser();
            String pw = ses.getPassword();
            String router = (String)request.getAttribute("P8BPM.wsCurrentCPName");
            if (router == null) {
                router = this.m_wsListenerProperties.getProperty("cm.router");
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "checkAccess", this.m_CEURI + "," + router);
            }
            if ((vwses = VWSessionManager.getVWSession(user, pw, router, this.m_CEURI)).isMemberOfGroup("SysAdminG")) {
                return true;
            }
        }
        catch (Throwable t) {
            logger.throwing(m_className, "checkAccess", t);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void adminFunctions(String pathInfo, String queryString, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        PrintWriter out;
        block38: {
            String s;
            BufferedReader reader;
            block37: {
                String m_method = "adminFunctions";
                int function = -1;
                int nAdmins = G_ADMIN_PATHS.length;
                for (int i = 0; i < nAdmins; ++i) {
                    if (!pathInfo.equals(G_ADMIN_PATHS[i])) continue;
                    function = i;
                    break;
                }
                if (function == 8) {
                    WSDLManager.ClearCaches();
                    return;
                }
                if (function == 9) {
                    this.processClassLoaderRequest(request, response);
                    return;
                }
                if (function == 15) {
                    this.printRequestInfo(request, response, false, true, null);
                    return;
                }
                if (this.m_wsListenerProperties == null || !this.checkAccess(request)) {
                    return;
                }
                switch (function) {
                    case 14: {
                        ClientInfoUtilities.ResetRPCTimingInfo();
                        break;
                    }
                    case 13: {
                        response.setContentType("text/html");
                        PrintWriter out2 = response.getWriter();
                        out2.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
                        out2.println("<html>");
                        out2.println("<head>");
                        out2.println("<title>SOAP Method statistics</title>");
                        out2.println("</head>");
                        out2.println("<body bgcolor=\"#d1d7b3\">");
                        out2.println("<h2><font color=\"#0000a0\">SOAP Method Statistics</font></h2>");
                        ClientInfoUtilities.PrintRPCTimingInfoAsHTML(out2);
                        out2.println("</body>");
                        out2.println("</html>");
                        out2.flush();
                        out2.close();
                        return;
                    }
                    case 12: {
                        this.processSetProperty(request, response);
                        return;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        String propValue;
                        String propName = function == 0 || function == 2 ? "filenet.ws.listener.tracing" : "filenet.ws.request.tracing";
                        String string = propValue = function == 0 || function == 1 ? "true" : "false";
                        if (logger.isFinest()) {
                            logger.finest(m_className, m_method, propName + "=" + propValue);
                        }
                        WSListenerProperties wSListenerProperties = this.m_wsListenerProperties;
                        synchronized (wSListenerProperties) {
                            this.m_wsListenerProperties.setProperty(propName, propValue);
                            break;
                        }
                    }
                    case 10: 
                    case 11: {
                        String propValue;
                        String propName = "filenet.pe.po.tracking";
                        String string = propValue = function == 10 ? "true" : "false";
                        if (logger.isFinest()) {
                            logger.finest(m_className, m_method, propName + "=" + propValue);
                        }
                        WSListenerProperties wSListenerProperties = this.m_wsListenerProperties;
                        synchronized (wSListenerProperties) {
                            this.m_wsListenerProperties.setProperty(propName, propValue);
                            break;
                        }
                    }
                    case 4: 
                    case 5: {
                        String fileName = this.m_wsListenerProperties.getProperty(function == 4 ? "filenet.ws.listener.tracefile" : "filenet.ws.request.tracefile");
                        if (fileName == null) break;
                        try {
                            File f = new File(fileName);
                            if (!f.exists()) break;
                            f.delete();
                        }
                        catch (Throwable t) {}
                        break;
                    }
                    case 6: 
                    case 7: {
                        reader = null;
                        out = null;
                        out = response.getWriter();
                        response.setContentType("text/plain");
                        String fileName = this.m_wsListenerProperties.getProperty(function == 6 ? "filenet.ws.listener.tracefile" : "filenet.ws.request.tracefile");
                        if (fileName != null) {
                            try {
                                File f = new File(fileName);
                                if (f.exists()) {
                                    out.println(fileName);
                                    reader = new BufferedReader(new FileReader(f));
                                    s = null;
                                    break block37;
                                }
                                out.println("No debug information.");
                                break block38;
                            }
                            catch (Throwable t) {
                                break block38;
                            }
                            finally {
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Exception e) {}
                                }
                            }
                        }
                        break block38;
                    }
                }
                this.printRequestInfo(request, response, false, true, null);
                return;
            }
            while ((s = reader.readLine()) != null) {
                out.println(s);
                if (s != null) continue;
            }
        }
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportTroubleInGet(Throwable exception, HttpServletResponse response) {
        PrintWriter writer = null;
        try {
            String s = VWException.DescribeThrowableCompletely(exception);
            logger.severe(m_className, "reportTroubleInGet", s);
            writer = response.getWriter();
            response.setContentType("text/html");
            response.setStatus(500);
            writer.println("<pre>Exception - " + s + "<br></pre>");
        }
        catch (Exception e) {
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String m_method = "doPost";
        logger.entering(m_className, "doPost");
        try {
            String axisPath;
            String s = request.getPathInfo();
            String pathInfo = "";
            if (s != null) {
                pathInfo = WSConstants.UTF8Decode(s);
            }
            try {
                pathInfo = this.getMyConnectionPoint4Request(pathInfo, request);
            }
            catch (VWException ex) {
                throw new ServletException((Throwable)ex);
            }
            if (pathInfo != null) {
                pathInfo = pathInfo.trim();
            }
            this.getWSListenerProperties((String)request.getAttribute("P8BPM.wsCurrentCPName"));
            this.setCEURI();
            this.setBaseURL(request);
            this.setListenerLocalHost(request);
            String queryString = request.getQueryString();
            if (logger.isFinest()) {
                logger.finest(m_className, "doPost", "pathInfo=" + pathInfo + ", queryString=" + queryString);
            }
            if (pathInfo != null && pathInfo.length() > 0) {
                request.setAttribute("P8BPM.wsListenerCurrentPath", (Object)pathInfo);
                if (logger.isFinest()) {
                    logger.finest(m_className, "doPost", "P8BPM.wsListenerCurrentPath=" + pathInfo);
                }
                if (pathInfo.startsWith("/uddiv2/")) {
                    pathInfo = "/uddiv2/";
                    if (logger.isFinest()) {
                        logger.finest(m_className, "doPost", "uddi pathInfo=" + pathInfo);
                    }
                } else if (pathInfo.startsWith("/RMService")) {
                    pathInfo = "/RMService";
                    if (logger.isFinest()) {
                        logger.finest(m_className, "doPost", "RMService pathInfo= " + pathInfo);
                    }
                }
            } else {
                pathInfo = "*";
            }
            if ((axisPath = wsMappings.getProperty(pathInfo)) == null) {
                axisPath = "/axis/services/P8BPMWSProcessor";
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "doPost", "forwarding to axisPath=" + axisPath);
            }
            request.getRequestDispatcher(axisPath).forward((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            logger.exiting(m_className, "doPost");
        }
    }

    private void printRequestInfo(HttpServletRequest request, HttpServletResponse response, boolean logOnly, boolean moreDetail, StringBuffer buf) throws IOException {
        String m_method = "printRequestInfo";
        if (buf == null) {
            buf = new StringBuffer();
        }
        buf.append("FILENET P8 BPM RESPONDED OK");
        String newsep = logOnly ? ", " : "\r\n";
        buf.append(newsep).append(m_listenerLocalHost);
        String version = WSListenerServlet.getVersion("filenet.vw.toolkit.utils.VWBuildStamp");
        buf.append(newsep).append(newsep).append("=== version: ").append(newsep).append(version);
        buf.append(newsep).append("Method: ").append(request.getMethod());
        buf.append(newsep).append("Request URI: ").append(request.getRequestURI());
        if (moreDetail) {
            buf.append(newsep).append("Protocol: ").append(request.getProtocol());
            if (request.getPathInfo() != null) {
                buf.append(newsep).append("PathInfo: ").append(WSConstants.UTF8Decode(request.getPathInfo()));
            }
            buf.append(newsep).append("ContextPath: ").append(request.getContextPath());
            buf.append(newsep).append("PathTranslated: ").append(request.getPathTranslated());
            buf.append(newsep).append("ServletPath: ").append(request.getServletPath());
            buf.append(newsep).append("QueryString: ").append(request.getQueryString());
            buf.append(newsep).append("Remote Address: ").append(request.getRemoteAddr());
            buf.append(newsep).append(newsep).append("=== Headers Information: ");
            Enumeration headerNamesEnum = request.getHeaderNames();
            if (headerNamesEnum != null) {
                while (headerNamesEnum.hasMoreElements()) {
                    String headerName = (String)headerNamesEnum.nextElement();
                    buf.append(newsep).append(headerName).append("=");
                    Enumeration headerValuesEnum = request.getHeaders(headerName);
                    if (headerValuesEnum == null) continue;
                    boolean moreToCome = false;
                    do {
                        buf.append(headerValuesEnum.nextElement());
                        moreToCome = headerValuesEnum.hasMoreElements();
                        if (!moreToCome) continue;
                        buf.append(",");
                    } while (moreToCome);
                }
            }
            buf.append(newsep).append(newsep).append("=== Parameter Information: ");
            Enumeration paramNamesEnum = request.getParameterNames();
            if (paramNamesEnum != null) {
                while (paramNamesEnum.hasMoreElements()) {
                    String paramName = (String)paramNamesEnum.nextElement();
                    buf.append(newsep).append(paramName).append("=").append(Logger.asString(request.getParameterValues(paramName)));
                }
            }
            buf.append(newsep).append(newsep).append("=== Request Attribute Information: ");
            Enumeration attributeNames = request.getAttributeNames();
            if (attributeNames != null) {
                while (attributeNames.hasMoreElements()) {
                    String attribName = (String)attributeNames.nextElement();
                    buf.append(newsep).append(attribName).append("=").append(Logger.asString(request.getAttribute(attribName)));
                }
            }
            buf.append(newsep).append(Logger.traceProperties("=== WSListenerServlet "));
            buf.append(newsep).append(newsep).append("=== My Config File=").append(P8BPMWSBROKER_PROPERTIES_FILENAME);
            buf.append(newsep).append(newsep).append("=== My Connection Point=").append((String)request.getAttribute("P8BPM.wsCurrentCPName"));
            if (this.m_wsListenerProperties != null) {
                buf.append(newsep).append(newsep).append("=== P8BPMWSBroker:");
                Enumeration<?> propNames = this.m_wsListenerProperties.propertyNames();
                if (propNames != null) {
                    while (propNames.hasMoreElements()) {
                        String propName = (String)propNames.nextElement();
                        String value = this.m_wsListenerProperties.getProperty(propName);
                        buf.append(newsep).append(propName).append("=").append(value);
                    }
                }
            } else {
                buf.append(newsep).append("No P8BPMWSBroker.properties is found!");
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "printRequestInfo", buf.toString());
            }
            if (logOnly) {
                return;
            }
            buf.append(newsep).append(GENERIC_HELP_STRING);
            int nLists = G_LIST_PATHS.length;
            buf.append(newsep).append(newsep).append("========= LIST FUNCTIONS ");
            for (int i = 0; i < nLists; ++i) {
                buf.append(newsep).append(G_LIST_PATHS[i]).append(G_LIST_PATHS_HELP[i]);
            }
            buf.append(newsep);
            int nAdmins = G_ADMIN_PATHS.length;
            buf.append(newsep).append(newsep).append("========= ADMIN FUNCTIONS ");
            for (int i = 0; i < nAdmins; ++i) {
                buf.append(newsep).append(G_ADMIN_PATHS[i]).append(G_ADMIN_PATHS_HELP[i]);
            }
            buf.append(newsep);
            buf.append(newsep).append("======== WcmApiConfig.properties ").append(newsep).append(this.traceWcmApiConfigProperties()).append(newsep);
        }
        try {
            buf.append("-------------------------\n");
            buf.append(ClientInfoUtilities.GetClientInfo());
        }
        catch (Exception e) {
            // empty catch block
        }
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        out.println("---------------------------------");
        out.println(buf.toString());
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getWorkClassWSDLorWF(HttpServletRequest request, HttpServletResponse response, String workClassPath, boolean wantWF, VWSession curVWSession) throws Throwable {
        block15: {
            String m_method = "getWorkClass(WSDL)orWF";
            if (wantWF) {
                m_method = "getWorkClassWSDLor(WF)";
            }
            logger.entering(m_className, m_method);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, workClassPath);
            }
            try {
                int jj;
                int len = workClassPath.length();
                for (jj = 0; jj < len && (workClassPath.charAt(jj) == ' ' || workClassPath.charAt(jj) == '/'); ++jj) {
                }
                if (jj == len) {
                    throw new MalformedURLException();
                }
                if (jj > 0) {
                    workClassPath = workClassPath.substring(jj);
                }
                int workspaceId = -1;
                int ii = workClassPath.lastIndexOf("/");
                if (ii > 0) {
                    String s = workClassPath.substring(ii + 1);
                    workClassPath = workClassPath.substring(0, ii);
                    if (s.length() > 0) {
                        try {
                            workspaceId = Integer.parseInt(s);
                        }
                        catch (Exception e) {
                            throw new VWException("filenet.ws.listener.http.WSListenerServlet.invalidWorkSpaceId", "Invalid work space id specified {0}.", s);
                        }
                    }
                }
                response.setContentType("text/xml; charset=UTF-8");
                response.getWriter().println(WSDLManager.genWorkClassWSDLorWF(workClassPath, workspaceId, this.m_wsListenerProperties, wantWF, (String)request.getAttribute("P8BPM.wsCurrentCPName"), curVWSession));
                if (wantWF || this.m_WSDLInit.booleanValue()) break block15;
                Object object = g_syncObject;
                synchronized (object) {
                    this.m_WSDLInit = Boolean.TRUE;
                }
            }
            finally {
                logger.exiting(m_className, m_method);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genDTD(HttpServletResponse response, String dtdName) throws Throwable {
        String dtdString = "filenet/vw/api/" + dtdName;
        String m_method = "genDTD:" + dtdString;
        logger.entering(m_className, m_method);
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            inStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(dtdString);
            int size = inStream.available();
            if (size > 0) {
                response.setContentType("text/plain");
                outStream = response.getOutputStream();
                for (int i = 0; i < size; ++i) {
                    outStream.write(inStream.read());
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Finished writing " + Integer.toString(size) + " bytes");
                }
            }
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception e) {}
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (Exception e) {}
            }
            logger.exiting(m_className, m_method);
        }
    }

    private void genWorkClassesInfo(HttpServletResponse response, String cpName, VWSession curVWSession) throws Throwable {
        String m_method = "genWorkClassesInfo";
        PrintWriter out = null;
        response.setContentType("text/html");
        out = response.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>WorkClasses Info for connection point: " + cpName + "</title></head><body>");
        try {
            if (curVWSession == null) {
                curVWSession = this.m_wsListenerProperties.getVWSession(cpName);
            }
            VWUserInfo user = curVWSession.fetchCurrentUserInfo();
            out.println("<p>Current User = " + user.getName() + "</p>");
            String[] theList = curVWSession.fetchLaunchableWorkClassNames();
            int nItems = theList == null ? 0 : theList.length;
            out.println("<p>Number of work classes that user can launch = " + Integer.toString(nItems) + "</p>");
            while (nItems > 0) {
                out.println("<br>" + theList[--nItems]);
            }
        }
        catch (Throwable t) {
            String s = VWException.DescribeThrowableCompletely(t);
            logger.severe(m_className, "genWorkClassesInfo", s);
            out.println("<b>");
            out.println(s);
            out.println("</b>");
        }
        out.println("</body></html>");
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void genQueuesInfo(HttpServletResponse response, String cpName, VWSession curVWSession) throws Throwable {
        String m_method = "genQueuesInfo";
        PrintWriter out = null;
        int fetchFlag = 37;
        response.setContentType("text/html");
        out = response.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Queues Info with fetchFlag = " + fetchFlag + " for connection point: " + cpName + "</title></head><body>");
        try {
            if (curVWSession == null) {
                curVWSession = this.m_wsListenerProperties.getVWSession(cpName);
            }
            out.println("<p>Use connection point = " + cpName + "</p>");
            VWUserInfo user = curVWSession.fetchCurrentUserInfo();
            out.println("<p>Current User = " + user.getName() + "</p>");
            String[] theList = curVWSession.fetchQueueNames(fetchFlag);
            int nItems = theList == null ? 0 : theList.length;
            out.println("<p>Number of queues = " + Integer.toString(nItems) + "</p>");
            while (nItems > 0) {
                out.println("<br>" + theList[--nItems]);
            }
        }
        catch (Throwable t) {
            String s = VWException.DescribeThrowableCompletely(t);
            logger.severe(m_className, "genQueuesInfo", s);
            out.println("<b>");
            out.println(s);
            out.println("</b>");
        }
        out.println("</body></html>");
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void genRostersInfo(HttpServletResponse response, String cpName, VWSession curVWSession) throws Throwable {
        String m_method = "genRostersInfo";
        PrintWriter out = null;
        response.setContentType("text/html");
        out = response.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Rosters Info for connection point: " + cpName + "</title></head><body>");
        try {
            if (curVWSession == null) {
                curVWSession = this.m_wsListenerProperties.getVWSession(cpName);
            }
            VWUserInfo user = curVWSession.fetchCurrentUserInfo();
            out.println("<p>Current User = " + user.getName() + "</p>");
            String[] theList = curVWSession.fetchRosterNames(false);
            int nItems = theList == null ? 0 : theList.length;
            out.println("<p>Number of rosters = " + Integer.toString(nItems) + "</p>");
            while (nItems > 0) {
                out.println("<br>" + theList[--nItems]);
            }
        }
        catch (Throwable t) {
            String s = VWException.DescribeThrowableCompletely(t);
            logger.severe(m_className, "genRostersInfo", s);
            out.println("<b>");
            out.println(s);
            out.println("</b>");
        }
        out.println("</body></html>");
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getUddiV2WSDL(HttpServletRequest request, HttpServletResponse response, String pathInfo) throws Throwable {
        String m_method = "getUddiV2WSDL:" + pathInfo;
        logger.entering(m_className, m_method);
        InputStream inStream = null;
        try {
            inStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("filenet/ws/listener/utils/inquire_v2.wsdl");
            response.setContentType("text/xml; charset=UTF-8");
            String wsdl = WSDLManager.genUddiV2WSDL(this.getBaseURLFromWSListenerProperties() + request.getPathInfo());
            response.getWriter().println(wsdl);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception e) {}
            }
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uddiv2Discovery(HttpServletResponse response, String queryString, String cpName, VWSession curVWSession) throws Throwable {
        String m_method = "uddiv2Discovery:" + cpName;
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, queryString);
        }
        try {
            if (curVWSession == null) {
                curVWSession = this.m_wsListenerProperties.getVWSession(cpName);
            }
            String discoveryResult = WSUddiManager.uddiDiscovery(curVWSession, this.getBaseURLFromWSListenerProperties(), queryString);
            response.setContentType("text/xml; charset=UTF-8");
            response.getWriter().println(discoveryResult);
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    private void loadWSDLClasses() {
        try {
            Class.forName("filenet.ws.api.WSDefinition");
            this.m_WSDLInit = Boolean.TRUE;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void processClassLoaderRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String error = null;
        String classLocation = null;
        String className = request.getParameter(CLASS_NAME);
        String classLoaderInfo = null;
        if (className != null && (className = className.trim()).length() != 0) {
            try {
                ProtectionDomain pd = Class.forName(className).getProtectionDomain();
                if (pd != null) {
                    CodeSource cs = pd.getCodeSource();
                    if (cs != null) {
                        classLocation = cs.toString();
                    } else {
                        error = "No CodeSource found!";
                    }
                    classLoaderInfo = Class.forName(className).getClassLoader().toString();
                } else {
                    error = "No ProtectionDomain found!";
                }
            }
            catch (Throwable t) {
                error = t.toString();
                this.log("error=" + t, t);
            }
        }
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Servlet Container Class Finder</title>");
        out.println("</head>");
        out.println("<body bgcolor=\"#d1d7b3\">");
        out.println("<h2><font color=\"#0000a0\">Servlet Container Class Finder</font></h2>");
        out.println("<p><font color=\"#000000\">Enter the fully-qualified name of a Java class");
        out.println("(e.g. org.apache.oro.text.regex.Perl5Compiler) in the field below. The");
        out.println("servlet will attempt to load the class and, if successful, query the");
        out.println("classes' <em>java.security.CodeSource</em> for the location of the class");
        out.println("using the following methods: <pre>");
        out.println("Class.forName(className).getProtectionDomain().getCodeSource()");
        out.println("</pre> </font></p>");
        out.println("<form method=\"get\" action=\"" + request.getRequestURI() + "\">");
        out.println("<p>Class Name: <input type=\"text\" name=\"classname\"");
        out.println("\tvalue=\"" + (className != null ? className : "") + "\" size=\"40\" /> <input type=\"submit\"");
        out.println("\tvalue=\"Submit\" /></p>");
        out.println("</form>");
        if (classLocation != null || error != null) {
            out.println("<table border=\"1\" bgcolor=\"#8080c0\">");
            out.println("\t<caption align=\"top\"><font color=\"#000000\">Search Results</font></caption>");
            out.println("\t<tbody>");
            out.println("\t\t<tr>");
            out.println("\t\t\t<td align=\"right\"><font color=\"#000000\">Class Name:</font></td>");
            out.println("\t\t\t<td><font color=\"#000000\">" + className + "</font></td>");
            out.println("\t\t</tr>");
            out.println("\t\t<tr>");
            if (error != null) {
                out.println("\t\t\t<td align=\"right\"><font color=\"#a00000\">Error:</font></td>");
                out.println("\t\t\t<td><font color=\"#a00000\">" + error + "</font></td>");
            } else {
                out.println("\t\t\t<td align=\"right\"><font color=\"#000000\">Class Location:</font></td>");
                out.println("\t\t\t<td><font color=\"#000000\">" + classLocation + "</font></td>");
                out.println("\t\t</tr>");
                out.println("\t\t<tr>");
                out.println("\t\t\t<td align=\"right\"><font color=\"#000000\">Class Loader:</font></td>");
                out.println("\t\t\t<td><font color=\"#000000\">" + classLoaderInfo + "</font></td>");
            }
            out.println("\t\t</tr>");
            out.println("\t</tbody>");
            out.println("</table>");
        }
        out.println("</body>");
        out.println("</html>");
        out.flush();
        out.close();
    }

    public static String _get_FILE_DATE() {
        return "2011/3/1";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "dts 948629";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setListenerLocalHost(HttpServletRequest request) {
        String m_method = "setListenerLocalHost";
        WSListenerServlet wSListenerServlet = this;
        synchronized (wSListenerServlet) {
            if (m_listenerLocalHost == null) {
                Integer localPort;
                String localHost;
                block15: {
                    localHost = null;
                    localPort = null;
                    Class<?> cls = request.getClass();
                    try {
                        Method getLocalNameMethod = cls.getMethod("getLocalName", null);
                        Method getLocalPortMethod = cls.getMethod("getLocalPort", null);
                        localHost = (String)getLocalNameMethod.invoke((Object)request, null);
                        localPort = (Integer)getLocalPortMethod.invoke((Object)request, null);
                    }
                    catch (Throwable t) {
                        if (!logger.isFinest()) break block15;
                        logger.throwing(m_className, "setListenerLocalHost", t);
                    }
                }
                if (localHost == null || WSConstants.isLoopbackAddress(localHost)) {
                    try {
                        localHost = InetAddress.getLocalHost().getHostName();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (localPort == null) {
                    localPort = request.getServerPort();
                }
                if (localHost != null) {
                    m_listenerLocalHost = localHost + (localPort != null ? ":" + localPort : "");
                }
                if ((m_listenerLocalHost == null || m_listenerLocalHost.trim().length() == 0) && this.m_wsListenerProperties != null) {
                    logger.finest(m_className, "setListenerLocalHost", "Read from P8BPMWSBroker.properties");
                    m_listenerLocalHost = this.m_wsListenerProperties.getProperty("listener.local.host");
                    if (m_listenerLocalHost != null && m_listenerLocalHost.trim().length() > 0 && m_listenerLocalHost.indexOf("host:###") != -1) {
                        m_listenerLocalHost = null;
                    }
                }
            }
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "setListenerLocalHost", m_listenerLocalHost);
        }
        if (m_listenerLocalHost != null) {
            request.setAttribute("P8BPM.listener.local.host", (Object)m_listenerLocalHost);
        }
    }

    private static String getVersion(String className) {
        if (className != null) {
            try {
                int nFields;
                Class<?> cls = Class.forName(className);
                Object obj = cls.newInstance();
                Field[] fields = cls.getFields();
                StringBuffer buf = new StringBuffer(512);
                buf.append(className).append("\n");
                int n = nFields = fields == null ? 0 : fields.length;
                while (--nFields > 0) {
                    String fieldName = fields[nFields].getName();
                    if (fieldName.equals("buildDateMask")) continue;
                    buf.append(fields[nFields].getName()).append("=").append(fields[nFields].get(obj)).append("\n");
                }
                return buf.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCEURI(ServletContext context) {
        String m_method = "getCEURI";
        InputStream configStream = null;
        try {
            logger.entering(m_className, "getCEURI");
            configStream = context.getResourceAsStream("/WEB-INF/WcmApiConfig.properties");
            if (configStream == null) {
                logger.severe(m_className, "getCEURI", "Cannot find WcmApiConfig.properties..");
            }
            this.m_CEURI = Configuration.GetCEURI(configStream, null);
            logger.info(m_className, "getCEURI", this.m_CEURI);
        }
        catch (Exception e) {
            logger.throwing(m_className, "getCEURI", e);
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                }
                catch (Exception e) {}
            }
            logger.exiting(m_className, "getCEURI");
        }
    }

    private void setCEURI() {
        if (this.m_CEURI != null && !this.m_CEURISet && this.m_wsListenerProperties != null) {
            if (this.m_wsListenerProperties.getProperty("DEBUG") == null || this.m_wsListenerProperties.getProperty("filenet.pe.bootstrap.ceuri") == null) {
                this.m_wsListenerProperties.setProperty("filenet.pe.bootstrap.ceuri", this.m_CEURI);
            }
            this.m_CEURISet = true;
        }
    }

    private String traceWcmApiConfigProperties() {
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        String m_method = "getWcmApiConfigProperties";
        InputStream configStream = null;
        try {
            Configuration g;
            configStream = context.getResourceAsStream("/WEB-INF/WcmApiConfig.properties");
            if (configStream == null) {
                logger.severe(m_className, "getWcmApiConfigProperties", "Cannot find WcmApiConfig.properties..");
            }
            if ((g = Configuration.GetGLOBALConfiguration(configStream, null)) != null) {
                return g.toString();
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, "getWcmApiConfigProperties", e);
        }
        if (configStream != null) {
            try {
                configStream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return "FAILED to get WcmApiConfig.properties!!";
    }

    private void genCPInfo(HttpServletResponse response) throws Throwable {
        String m_method = "genCPInfo";
        if (this.m_wsListenerProperties == null) {
            return;
        }
        PrintWriter out = null;
        try {
            String ceURI = this.m_wsListenerProperties.getProperty("filenet.pe.bootstrap.ceuri");
            String name = this.m_wsListenerProperties.getUserName();
            String pw = this.m_wsListenerProperties.getPassword();
            ConnectionPoint[] cps = ConnectionPoints.GetConnectionPoints(ceURI, name, pw);
            response.setContentType("text/html");
            out = response.getWriter();
            out.println("<html>");
            out.println("<head>");
            out.println("<title>Connection Point information</title>");
            out.println("</head>");
            int nCps = cps == null ? 0 : cps.length;
            out.println("<body>");
            out.println("<p>Number of defined connection points = " + Integer.toString(nCps) + "</p>");
            while (nCps > 0) {
                out.println("<br>" + cps[--nCps]);
            }
            out.println("</body></html>");
        }
        catch (Throwable t) {
            logger.severe(m_className, "genCPInfo", t.getMessage());
            throw t;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void listFunctions(String pathInfo, String queryString, HttpServletRequest request, HttpServletResponse response, VWSession curVWSession) throws Throwable {
        String m_method = "listFunctions";
        int function = 3;
        int nLists = G_LIST_PATHS.length;
        for (int i = 0; i < nLists; ++i) {
            if (!pathInfo.equals(G_LIST_PATHS[i])) continue;
            function = i;
            break;
        }
        String cpName = (String)request.getAttribute("P8BPM.wsCurrentCPName");
        switch (function) {
            case 0: {
                if (this.m_wsListenerProperties != null) {
                    this.genCPInfo(response);
                }
                return;
            }
            case 1: {
                this.genQueuesInfo(response, cpName, curVWSession);
                return;
            }
            case 2: {
                this.genRostersInfo(response, cpName, curVWSession);
                return;
            }
            case 3: 
            case 4: {
                this.genWorkClassesInfo(response, cpName, curVWSession);
                return;
            }
        }
    }

    private void fetchXSD(String pathInfo, String queryString, HttpServletRequest request, HttpServletResponse response, VWSession curVWSession) throws Throwable {
        int _xsd_Index;
        String m_method = "fetchXSD:" + pathInfo;
        logger.entering(m_className, m_method);
        if (curVWSession == null) {
            String cpName = (String)request.getAttribute("P8BPM.wsCurrentCPName");
            curVWSession = this.m_wsListenerProperties.getVWSession(cpName);
        }
        if ((_xsd_Index = pathInfo.indexOf(Constants._XSD_)) == -1) {
            return;
        }
        String schemaFileName = pathInfo.substring(_xsd_Index + Constants._XSD_.length());
        WSSchemaUtilsEx ws = PESchemaHelper.GetSchemaFromServer(curVWSession, schemaFileName, this.getMyRequestBaseURL(request));
        String mainSchema = ws.getMainSchema();
        response.setContentType("text/xml");
        response.getWriter().write(mainSchema);
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, mainSchema);
        }
        logger.exiting(m_className, m_method);
    }

    private String getCPFromPath(String pathInfo, String prefix) {
        String m_method = "getCPFromPath:" + pathInfo + "," + prefix;
        if (pathInfo.equals(prefix)) {
            return null;
        }
        String s = pathInfo.substring(prefix.length());
        if (s.length() == 0) {
            return null;
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, s);
        }
        return s;
    }

    private void UDDIFunctions(String pathInfo, String queryString, HttpServletRequest request, HttpServletResponse response, VWSession curVWSession) throws Throwable {
        if (pathInfo.startsWith("/uddiv2/discovery")) {
            if (queryString != null) {
                this.uddiv2Discovery(response, queryString, (String)request.getAttribute("P8BPM.wsCurrentCPName"), curVWSession);
            }
            return;
        }
        if (pathInfo.startsWith("/uddiv2/inquire") && (queryString == null || queryString.startsWith("wsdl"))) {
            this.getUddiV2WSDL(request, response, pathInfo);
            return;
        }
    }

    private static final void setPrivilegedSystemProperty(String propName, String propValue) {
        final String fpropName = propName;
        final String fValue = propValue;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (fValue != null) {
                    System.setProperty(fpropName, fValue);
                } else {
                    System.getProperties().remove(fpropName);
                }
                return null;
            }
        });
    }

    private void processSetProperty(HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append("<SetPropertyCall ");
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String propName = (String)names.nextElement();
            String propValue = request.getParameter(propName);
            WSListenerServlet.setPrivilegedSystemProperty(propName, propValue);
            buf.append(" ").append(propName).append("=\"").append(XMLHelper.toXMLString(propValue)).append("\"");
        }
        buf.append("/>");
        response.setContentType("text/xml");
        PrintWriter out = response.getWriter();
        out.println(buf.toString());
        out.close();
    }

    static {
        WSRMCallback cb = WSRMCallback.getCallbackInstance();
        WSRMProvider.setCallback(cb);
        Sender.setCallback((Callback)cb);
        SenderWorker.setCallback((Callback)cb);
        WSUUIDGenFactory.getUUIDGen();
        g_syncObject = new Object();
        logger = Logger.getLogger("filenet.ws.listener.http");
        syncObj = new Object();
        P8BPMWSBROKER_PROPERTIES_LAST_MODIFIED = 0L;
        wsMappings = new Properties();
        P8BPMWSBROKER_PROPERTIES_FILENAME = null;
        LOCAL_P8BPMWSBROKER_PROPERTIES_FILENAME = null;
        LF = "\r\n";
        GENERIC_HELP_STRING = LF + "================ HELP FUNCTIONS === " + LF + "{URLs should be UTF-8 encoded" + LF + "/wc/<WorkflowDefinition>?wf == list the XML of the runtime workflow in the current workspace for the default connection point" + LF + "/wc/<WorkflowDefinition>?wsdl == list the WSDL of the workflow in the current workspace for the default connection point" + LF + "/wc/<WorkflowDefinition>/<workspaceID>?wf == list the XML of the runtime workflow in the indicated workspace for the default connection point" + LF + "/wc/<WorkflowDefinition>/<workspaceID>?wsdl == list the WSDL of the workflow in the indicated workspace for the default connection point" + LF + "/wscp<ConnectionPointName>/list == list the runtime workflows available for the indicated connection point." + LF + "/wscp<ConnectionPointName>/wc/<WorkflowDefinition>?wf == list the XML of the runtime workflow in the current workspace for the indicated connection point" + LF + "/wscp<ConnectionPointName>/wc/<WorkflowDefinition>?wsdl == list the WSDL of the workflow in the current workspace for the indicated connection point" + LF + "/wscp<ConnectionPointName>/wc/<WorkflowDefinition>/<workspaceID>?wf == list the XML of the runtime workflow in the indicated workspace for the indicated connection point" + LF + "/wscp<ConnectionPointName>/wc/<WorkflowDefinition>/<workspaceID>?wsdl == list the WSDL of the workflow in the indicated workspace for the indicated connection point" + LF + "/uddiv2/inquire" + LF + "/uddiv2/discovery" + LF + "/_xsd_/<PEServerSchemaname>" + LF + LF + "username and pw can be passed as query string user=<username>&pw=<pw> to the list, wf, or wsdl functions" + " in addition to the /wscp<ConnectionPoint> pathInfo -- this is helpful when CM is not yet configured." + "  For example: http://hqamber:9080/Workplace/P8BPMWSBroker/wscphqruby_600/listqueues?user=pwtestadmin&pw=xtx";
        G_ADMIN_PATHS = new String[]{"/admin/dbgon", "/admin/req/dbgon", "/admin/dbgoff", "/admin/req/dbgoff", "/admin/dbgclear", "/admin/req/dbgclear", "/admin/dbgshow", "/admin/req/dbgshow", "/admin/clearcaches", "/admin/classloader", "/admin/trackingon", "/admin/trackingoff", "/admin/setproperty", "/admin/stats", "/admin/resetStats", "/admin/help"};
        G_ADMIN_PATHS_HELP = new String[]{" == Enable filenet.ws.listener.tracing", " == Enable filenet.ws.request.tracing", " == Disable filenet.ws.listener.tracing", " == Disable filenet.ws.request.tracing", " == Removing the file indicated by property filenet.ws.listener.tracefile", " == Removing the file indicated by property filenet.ws.request.tracefile", " == Showing the contents of the file indicated by property filenet.ws.listener.tracefile", " == Showing the contents of the file indicated by property filenet.ws.request.tracefile", " == Clearing WSDL caches", " == Class loader helper", " == enable POTrackingFilter", " == disable POTrackingFilter", " == setting system property", " == viewing PE API RPC timing info", " == reset PE API RPC timing info", " == help & misc. items"};
        m_listenerLocalHost = null;
        G_LIST_PATHS = new String[]{"/listcp", "/listqueues", "/listrosters", "/listwc", "/list"};
        G_LIST_PATHS_HELP = new String[]{" == List Connection Points defined for Component Manager", " == List Queues", " == List Rosters", " == List Work classes transferred for the connection points", " == List Work classes -- same as listwc"};
    }
}

